// matrixes
float4x4 matViewProj;
float4x4 matWorld;

struct VS_INPUT{
	float4 position: POSITION;
};


struct VS_OUTPUT{
	float4 position: POSITION;
	float3 pos: TEXCOORD0;
};


VS_OUTPUT vs_main(VS_INPUT input){
	VS_OUTPUT Out = (VS_OUTPUT)0;
	float4 objectPosition = input.position;
	float4 worldPosition = mul(objectPosition, matWorld);
	Out.position = mul(worldPosition, matViewProj);
	Out.pos = worldPosition;
	
	return Out;
}



sampler attenuationMap;
float3 viewPosition;
float3 lightPosition;
float4 lightColor;
float lightRadius;
float density;
float volumeLightIntensity;

float4 ps_main(float3 pos: TEXCOORD0):COLOR0{
	// volume light
	float3 lightVec = lightPosition-pos;
	float3 viewVec = viewPosition-pos;
	float k = saturate(dot(lightVec, viewVec) / dot(viewVec, viewVec));
	float3 pl = k * viewVec - lightVec;
	float l = length(pl)/lightRadius;
	float dens = pow(tex3D(attenuationMap, float3(l,0,0)), 1.5);
	
	// fog
	density *= 2;
	float dist = distance(lightPosition, viewPosition);
	float fog = 1/pow(2.18, dist*dist*density*density);
	
	return dens*lightColor*volumeLightIntensity * fog;
}
